/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.general.comun;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70TrazaInterface;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;

public class EstaticosClsTrazas
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CODAPLICACION = Q70ListenerUtils.getApplicationProperty((String)"COD_APLICACION");
    public static final Logger log = new ConsoleLogger(1);
    private static final String COD_APLICACION = Q70ListenerUtils.getApplicationProperty((String)"COD_APLICACION");
    private static Q70TrazaInterface tr = Q70Factoria.getTraza();

    private EstaticosClsTrazas() {
    }

    public static void debug(String componente) {
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.DEBUG, EstaticosClsTrazas.formateaCadena(componente));
        }
        EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(componente) + "\n");
    }

    public static void debug(String componente, Object obj) {
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.DEBUG, EstaticosClsTrazas.formateaCadena(String.valueOf(componente) + ": " + obj.toString()));
        }
        EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(componente) + ": " + obj.toString() + "\n");
    }

    public static void debug(String componente, Object cadena, Class clase) {
        if (tr.isTraceActive()) {
            if (cadena != null) {
                tr.trace(CODAPLICACION, Q70TraceLevel.DEBUG, EstaticosClsTrazas.formateaCadena(String.valueOf(componente) + ": " + cadena.toString()));
            } else {
                tr.trace(CODAPLICACION, Q70TraceLevel.DEBUG, EstaticosClsTrazas.formateaCadena(componente));
            }
        }
        if (cadena != null) {
            EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(clase.getName()) + " -> " + componente + ": " + cadena.toString());
        } else {
            EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(clase.getName()) + " -> " + componente);
        }
        EstaticosClsTrazas.fncEscribeEnConsola("\n");
    }

    public static void info(String componente) {
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.INFO, EstaticosClsTrazas.formateaCadena(componente));
        }
        EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(componente) + "\n");
    }

    public static void error(String componente, Object obj) {
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.ERROR, EstaticosClsTrazas.formateaCadena(String.valueOf(componente) + ": " + obj.toString()));
        }
        EstaticosClsTrazas.fncEscribeEnConsolaFatal(String.valueOf(componente) + ": " + obj.toString() + "\n");
    }

    public static void error(Exception e) {
        String cadena = e.toString();
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.ERROR, EstaticosClsTrazas.formateaCadena(cadena));
        }
        EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(cadena) + "\n");
    }

    public static void fatal(String componente, Object obj) {
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.FATAL, EstaticosClsTrazas.formateaCadena(String.valueOf(componente) + ": " + obj.toString()));
        }
        EstaticosClsTrazas.fncEscribeEnConsolaFatal(String.valueOf(componente) + ": " + obj.toString() + "\n");
    }

    public static void depuraBD(String componente, Object obj) {
        if (tr.isTraceActive()) {
            tr.trace(CODAPLICACION, Q70TraceLevel.DEBUG, EstaticosClsTrazas.formateaCadena(String.valueOf(componente.toUpperCase()) + ": " + obj.toString()));
        }
        EstaticosClsTrazas.fncEscribeEnConsola(String.valueOf(componente.toUpperCase()) + ": " + obj.toString() + "\n");
    }

    public static String fncTrazaSQL(String sqlP, List arrCampos) {
        String sql = sqlP;
        if (arrCampos != null) {
            StringBuffer retSql = new StringBuffer();
            boolean seguro = false;
            if ((sql = sql.toUpperCase()).charAt(sql.length() - 1) == '?') {
                sql = sql.concat("SEGURO");
                seguro = true;
            }
            StringTokenizer interrogante = new StringTokenizer(sql, "?");
            int i = 0;
            while (interrogante.hasMoreTokens()) {
                retSql.append(interrogante.nextToken());
                if (!interrogante.hasMoreTokens()) continue;
                if (i > arrCampos.size() - 1) {
                    return "El array de campos tiene menos campos que interrogantes la sentencia SQL";
                }
                Object campo = arrCampos.get(i);
                if (campo == null || campo.equals("")) {
                    return "El array de campos contiene una posicion a Null o String vacio en la posici\u00f3n " + i;
                }
                if (campo instanceof String) {
                    if (campo.toString().equals("CLS_NULO_STRING")) {
                        retSql.append("NULL");
                    } else if (campo.toString().equals("CLS_NULO_INTEGER")) {
                        retSql.append("NULL");
                    } else if (campo.toString().equals("CLS_NULO_DATE")) {
                        retSql.append("NULL");
                    } else if (campo.toString().equals("CLS_NULO_FLOAT")) {
                        retSql.append("NULL");
                    } else if (campo.toString().equals("CLS_NULO_DOUBLE")) {
                        retSql.append("NULL");
                    } else {
                        retSql.append("'");
                        retSql.append(campo.toString());
                        retSql.append("'");
                    }
                } else if (campo instanceof Integer || campo instanceof Double) {
                    retSql.append(campo.toString());
                } else {
                    retSql.append(campo.toString());
                }
                ++i;
            }
            if (i != arrCampos.size()) {
                return "La sentencia SQL tiene menos interrogantes que el array de campos posiciones";
            }
            if (seguro) {
                retSql.delete(retSql.length() - 6, retSql.length());
            }
            return EstaticosClsTrazas.fncFormateaQuery(retSql.toString());
        }
        return EstaticosClsTrazas.fncFormateaQuery(sql);
    }

    private static String fncFormateaQuery(String sql) {
        int numCaracteres = 0;
        StringBuffer retSql = new StringBuffer();
        StringTokenizer espacio = new StringTokenizer(sql, " ");
        boolean primera = true;
        retSql.append("\n");
        while (espacio.hasMoreTokens()) {
            String palabra = espacio.nextToken();
            if (!(!primera || "SELECT".equals(palabra) || "UPDATE".equals(palabra) || "INSERT".equals(palabra) || "DELETE".equals(palabra))) {
                return "La sentencia SQL no parece valida";
            }
            primera = false;
            if ("FROM".equals(palabra) || "AND".equals(palabra) || "ORDER".equals(palabra) || "GROUP".equals(palabra) || "WHERE".equals(palabra) || "SET".equals(palabra)) {
                retSql.append("\n");
                retSql.append(palabra);
                retSql.append(" ");
                numCaracteres = palabra.length() + 1;
                continue;
            }
            if ("UNION".equals(palabra)) {
                retSql.append("\n");
                retSql.append(" ");
                retSql.append(palabra);
                retSql.append("\n");
                numCaracteres = 0;
                continue;
            }
            if (numCaracteres + palabra.length() + 1 > 79) {
                retSql.append("\n");
                numCaracteres = 0;
            }
            retSql.append(palabra);
            retSql.append(" ");
            numCaracteres += palabra.length() + 1;
        }
        retSql.deleteCharAt(retSql.length() - 1);
        retSql.append(";");
        return retSql.toString();
    }

    private static void fncEscribeEnConsola(String traza) {
        String strEntornoAplic = Q70ListenerUtils.getApplicationProperty((String)("ENTORNO_" + COD_APLICACION.toUpperCase()));
        if ("LOCAL".equals(strEntornoAplic)) {
            log.info(traza);
        }
    }

    private static void fncEscribeEnConsolaFatal(String traza) {
        String strEntornoAplic = Q70ListenerUtils.getApplicationProperty((String)("ENTORNO_" + COD_APLICACION.toUpperCase()));
        if ("LOCAL".equals(strEntornoAplic)) {
            log.fatalError(traza);
        }
    }

    public static void depura(String string, String string2) {
        EstaticosClsTrazas.debug(string, string2);
    }

    public static void depura(String string, Map objRegistro) {
        EstaticosClsTrazas.debug(string);
    }

    public static void depura(String string) {
        EstaticosClsTrazas.debug(string);
    }

    private static String formateaCadena(String texto) {
        String cadenaLimpia = texto.replaceAll("'", "\"");
        cadenaLimpia = cadenaLimpia.replaceAll(";", " ");
        cadenaLimpia = cadenaLimpia.replaceAll("/n", " ");
        return cadenaLimpia;
    }
}

